package orchestrator.plus;


import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

import orchestrator.Orchestrator;


import service.ComposedTransition;
import service.ComposedState;
import service.ServiceFactory;
import service.SimpleTransition;
import service.SimpleState;
import service.State;
import service.TransitionSystem;
import simulator.plus.SimilarState;
import simulator.plus.SimulationPlusImpl;
import simulator.Simulation;
import simulator.SimulationFactoryImpl;



public class OrchestratorPlusImpl extends Orchestrator {
	SimulationPlusImpl sym;
	SimpleState currentTargetState;
	ComposedState currentServicesState;
	ComposedTransition lastExecutedAction=null;
	TransitionSystem<SimpleState, SimpleTransition> target;
	TransitionSystem<SimpleState, SimpleTransition>[] availableServices;
	Vector<TransitionResultEntry> transition;

	TransitionSystem<SimpleState, SimpleTransition>[] available;
	/**
	 * Creates a new orchestrator for the given target services and available services
	 * @param target the transition system of the target service
	 * @param availableServices the transition systems of the available services
	 * @throws Exception an orchestrator cannot be created with the given parameters
	 */
	public OrchestratorPlusImpl(TransitionSystem<SimpleState, SimpleTransition> target,
			TransitionSystem<SimpleState, SimpleTransition>[] availableServices,
			ServiceFactory serviceFactory) throws Exception {
		super(target, availableServices);
		this.sym=(new SimulationFactoryImpl()).createSimulationPlus(target,availableServices,serviceFactory);
		this.available=availableServices;
		this.currentTargetState=target.getInitial();
		this.target=target;
		this.availableServices=availableServices;
		this.currentServicesState=this.sym.getCompositionTs().getInitial();
		transition=createTransitions();
	}
	
	@SuppressWarnings("unchecked")
	private Vector<TransitionResultEntry> createTransitions() throws Exception{
		Vector<TransitionResultEntry> result=new Vector<TransitionResultEntry>();
		TransitionSystem<ComposedState, ComposedTransition> compositionTS=getCompositionTs();
		Set<SimilarState> setSimilarState=sym.getAllSimilarState1();
		Iterator<SimilarState> itSimulationCouple=setSimilarState.iterator();
		while(itSimulationCouple.hasNext()){
			SimilarState currentSimulationCouple=itSimulationCouple.next();
			Iterator<SimpleTransition> itSimpleAction=target.getActionsOf(currentSimulationCouple.getTargetState()).iterator();
			while(itSimpleAction.hasNext()){
				SimpleTransition simpleAction=itSimpleAction.next();
				Iterator<ComposedTransition> itComposedAction=compositionTS.getActionsOfStateWithName(currentSimulationCouple.getAvalableServiceState(),simpleAction.getName()).iterator();			
				TransitionResultEntry newTransition=new TransitionResultEntry(
						currentSimulationCouple.getTargetState(),
						currentSimulationCouple.getAvalableServiceState(),
					    simpleAction
					    );				
				while(itComposedAction.hasNext()){
					ComposedTransition currentComposedAction=itComposedAction.next();
					newTransition.addTransitionSystemInTransition((TransitionSystem<SimpleState, SimpleTransition>) currentComposedAction.getService());
				}
				result.add(newTransition);
			}
		}
		Collections.sort(result);
		return result;
	}


	
	@Override
	public void doAction(SimpleTransition action) throws Exception{
		Set<SimpleTransition> actions=this.sym.getTargetTs().getActionsOf(currentTargetState);
		if(!actions.contains(action))
			throw new Exception("Selected action is not available");
		Iterator<ComposedTransition> it=this.sym.getCompositionTs().getActionsOf(currentServicesState).iterator();
		ComposedTransition current=null;
		while(it.hasNext()){
			current=it.next();
			if(current.actionSimulates(action)){
				this.currentServicesState=current.getStateTo();
				this.currentTargetState=(SimpleState)action.getStateTo();//TODO check cast
				this.lastExecutedAction=current;
			}
		}
	}
	public Vector<String[]> getSimulationDataToExport(){
		Set<SimilarState> similarStates=sym.getAllSimilarState1();
		Vector<SimilarState> resultSimilarState=new Vector<SimilarState>(similarStates.size());
		Iterator<SimilarState> itSimilarStates=similarStates.iterator();
		while(itSimilarStates.hasNext())
			resultSimilarState.add(itSimilarStates.next());
		Collections.sort(resultSimilarState);

		Vector<String[]> result=new Vector<String[]>(similarStates.size());
		for(int i=0;i<resultSimilarState.size();i++){
			result.add(resultSimilarState.elementAt(i).toStringArray());
		}
		return result;
	}
	public Vector<String[]> getCompositionDataToExport(){
		Vector<String[]> result=new Vector<String[]>();
		Iterator<TransitionResultEntry> itTransition=transition.iterator();
		while(itTransition.hasNext())
			result.add(itTransition.next().toStringArray());
		return result;
	}

	public SimpleState getCurrentTargetState() {
		return currentTargetState;
	}

	public ComposedState getCurrentServicesState() {
		return currentServicesState;
	}
	public ComposedTransition getLastExecutedAction() {
		return lastExecutedAction;
	}

	public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
		
		return sym.getCompositionTs();
	}


	public Simulation getSimulation() {
		return sym;
	}
	public Vector<TransitionResultEntry> getTransition(){
		return transition;
	}


	/* (non-Javadoc)
	 * @see orchestrator.Orchestrator#getAsyncProduct()
	 */
	@Override
	public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
		return sym.getAsyncProduct();
	}

	/* (non-Javadoc)
	 * @see orchestrator.Orchestrator#getAllSimilarState()
	 */
	@Override
	public Set<State[]> getAllSimilarState() {
		return 		sym.getAllSimilarState();
	}

	
}
